let translate = window.FC.fct
let fieldHTML = []
let fieldOptions = []

let columnWidthTemplate = `<label class='w-1'><span>Col. Width</span><input type='text' ng-model='element.elementDefaults.field_width'><i data-html='true' tooltip data-placement='top' data-toggle='tooltip' title='${translate['Set Width Option']}<img src="${FC.pluginurl}/assets/images/width-info.png" style="width: 190px; height: auto; display: block"/>' class='formcraft-icon tooltip-icon'>info_outline</i></label>`
let labelAndSubLabelTemplate = '<label class="w-1"><span>Label</span><input fc-placeholder type="text" ng-model="element.elementDefaults.main_label"></label><label class="w-1"><span>Sub Label</span><input sub-label type="text" ng-model="element.elementDefaults.sub_label"></label>'
let instructionsTemplate = '<label class="w-2"><span>Instructions</span><input type="text" ng-model="element.elementDefaults.instructions"></label>'
let altLabelTemplate = `<label class="w-1"><span>Alt Label</span><input type="text" ng-model="element.elementDefaults.altLabel"><i data-html="true" tooltip data-placement="top" data-toggle="tooltip" title="<div style='width: 150px'>${translate['Alt Label']}</div>" class="formcraft-icon tooltip-icon">info_outline</i></label>`
let instructionsAltTemplate = `<label class="w-1"><span>Instructions</span><input type="text" ng-model="element.elementDefaults.instructions"></label><label class="w-1"><span>Alt Label</span><input type="text" ng-model="element.elementDefaults.altLabel"><i data-html="true" tooltip data-placement="top" data-toggle="tooltip" title="<div style='width: 150px'>${translate['Alt Label']}</div>" class="formcraft-icon tooltip-icon">info_outline</i></label>`
let hideFieldTemplate = '<label class="w-3"><input value="1" type="checkbox" ng-model="element.elementDefaults.hidden_default"> Hide Field on Page Load</label>'

fieldHTML.heading = '<div style="background-color: {{element.elementDefaults.background_color}}" class="heading-cover field-cover"><div style="text-align: {{element.elementDefaults.headingAlignment}}; font-size: {{element.elementDefaults.headingSize}}em; padding-top: {{element.elementDefaults.paddingTop}}; padding-bottom: {{element.elementDefaults.paddingBottom}}; color: {{element.elementDefaults.font_color}}" class="bold-{{element.elementDefaults.headingWeight}}" compilesafe="element.elementDefaults.field_value"></div><input type="hidden" data-field-id="{{element.identifier}}" name="{{element.identifier}}[]" value="{{element.elementDefaults.field_value}}"></div>'
fieldOptions.heading = `<label class='w-2'><span>Label</span><input fc-placeholder type='text' ng-model='element.elementDefaults.main_label'></label>${columnWidthTemplate}<label class='w-2'><span>Heading Text</span><input sub-label type='text' ng-model='element.elementDefaults.field_value'></label>${altLabelTemplate}<label class='w2-1'><span>Padding Top</span><input type='text' ng-model='element.elementDefaults.paddingTop' placeholder='10px'/></label><label class='w2-1'><span>Padding Bottom</span><input type='text' ng-model='element.elementDefaults.paddingBottom' placeholder='10px'/></label><div class='w-3'><div>Format</div><div class='button-checkbox-group'><label ng-click='element.elementDefaults.headingSize = element.elementDefaults.headingSize + 0.1' title='Increase font size'>A+</label><label ng-click='element.elementDefaults.headingSize = element.elementDefaults.headingSize - 0.1' title='Decrease font size'>A-</label></div><div class='button-checkbox-group' style='margin-left: 1em'><label style='font-weight: bold' title='Bold text'>B<input type='checkbox' value='bold' ng-model='element.elementDefaults.headingWeight' update-label/></label></div><div class='button-checkbox-group' style='margin-left: 1em'><label><i class='formcraft-icon'>format_align_left</i><input type='radio' value='left' ng-model='element.elementDefaults.headingAlignment' update-label/></label><label><i class='formcraft-icon'>format_align_center</i><input type='radio' value='center' ng-model='element.elementDefaults.headingAlignment' update-label/></label><label><i class='formcraft-icon'>format_align_right</i><input type='radio' value='right' ng-model='element.elementDefaults.headingAlignment' update-label/></label></div></div><div class='w-3'><p style='width: 161px'>Font Color</p><input angular-color type='text' value='#fff' class='color-picker' ng-model='element.elementDefaults.font_color'></div><div class='w-3'><p style='width: 161px'>Background Color</p><input angular-color type='text' value='#fff' class='color-picker' ng-model='element.elementDefaults.background_color'></div>${hideFieldTemplate}`

fieldHTML.oneLineText = '<label class="oneLineText-cover field-cover"><span class="sub-label-{{element.elementDefaults.has_sub_label}}"><span compilesafe="element.elementDefaults.main_label" class="main-label"></span><span class="sub-label" compilesafe="element.elementDefaults.sub_label"></span></span><div><span class="error"></span><input type="text" placeholder="{{element.elementDefaults.main_label_placeholder}}" make-read-only="{{element.elementDefaults.readonly}}" data-field-id="{{element.identifier}}" name="{{element.identifier}}[]" data-min-char="{{element.elementDefaults.Validation.minChar}}" data-max-char="{{element.elementDefaults.Validation.maxChar}}" data-val-type="{{element.elementDefaults.Validation.allowed}}" data-regexp="{{element.elementDefaults.Validation.regexp}}" data-is-required="{{element.elementDefaults.required}}" data-allow-spaces="{{element.elementDefaults.Validation.spaces}}" class="validation-lenient" data-placement="right" data-toggle="tooltip" tooltip title="{{element.elementDefaults.instructions}}" data-trigger="focus" data-html="true" data-input-mask="{{element.elementDefaults.mask}}" data-mask-placeholder="{{element.elementDefaults.maskPlaceholder}}"><i class="formcraft-icon formcraft-icon-type-{{element.elementDefaults.selectedIcon}}">{{element.elementDefaults.selectedIcon}}</i></div></label>'
fieldOptions.oneLineText = `${labelAndSubLabelTemplate}${columnWidthTemplate}${instructionsAltTemplate}<div class='w-1 icons-list'><div><span>Icon</span><div class='select-icon-cover'><span ng-click='showIcons($parent.$index, $index)' class='select-icon'><i class='formcraft-icon'>{{element.elementDefaults.selectedIcon}}</i></span></div></div></div><label class='w2-1'><span>Input Mask</span><input type='text' ng-model='element.elementDefaults.mask'><i data-html='true' tooltip data-placement='top' data-toggle='tooltip' title='<strong>Common Masks:</strong><br><strong>US Telephone:</strong> (000) 000-0000<br><strong>Zip Code:</strong> 0000-000<br><strong>Social Security:</strong> 000-00-0000<br><strong>CPF:</strong> 000.000.000-00<br><strong>Legend:</strong><br><strong>0</strong> = allow 0 - 9<br><strong>A</strong> = allow a - z, or 0 - 9<br><strong>S</strong> = allow a - z' class='formcraft-icon tooltip-icon'>info_outline</i></label><label class='w2-1'><span>Mask Placeholder</span><input type='text' ng-model='element.elementDefaults.maskPlaceholder'></label><label class='w-3'><span>Validation</span><select ng-model='element.elementDefaults.Validation.allowed'><option value=''>None</option><option value='alphabets'>Only Alphabets</option><option value='numbers'>Only Numbers</option><option value='alphanumeric'>Only Alphabets & Numbers</option><option value='url'>URL</option><option value='regexp'>RegEx</option></select></label><label ng-slide-toggle='element.elementDefaults.Validation.allowed=="regexp"' class='w-3'><span>RegEx</span><input type='text' ng-model='element.elementDefaults.Validation.regexp'><i data-html='true' tooltip data-placement='top' data-toggle='tooltip' title='<strong>Common RegExp:</strong><br><strong>/^[a-z0-9_-]{6,18}$/</strong>: allow only alphabets, numbers, underscore and hyphen, and between 6 to 18 characters.<br><strong>/^[a-z0-9-]+$/</strong>: allow only alphabets, numbers and hyphens.<br><strong>/^[a-zA-Z]*$/</strong>: alphabets only, lower or upper case<br><strong>/^[0-9]*$/</strong>: digits only' class='formcraft-icon tooltip-icon'>info_outline</i></label><label class='w2-1'><span>Min Chars</span><input type='text' ng-model='element.elementDefaults.Validation.minChar'></label><label class='w2-1'><span>Max Chars</span><input type='text' ng-model='element.elementDefaults.Validation.maxChar'></label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.Validation.spaces'> Allow Spaces</label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.required'> Required Field</label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.readonly'> Read-Only Field</label>${hideFieldTemplate}`

fieldHTML.email = '<label class=\'email-cover field-cover\'><span class=\'sub-label-{{element.elementDefaults.has_sub_label}}\'><span compilesafe=\'element.elementDefaults.main_label\' class=\'main-label\'></span><span class=\'sub-label\' compilesafe=\'element.elementDefaults.sub_label\'></span></span><div><span class=\'error\'></span><input placeholder=\'{{element.elementDefaults.main_label_placeholder}}\' data-field-id=\'{{element.identifier}}\' type=\'text\' data-val-type=\'email\' make-read-only="{{element.elementDefaults.readonly}}" data-is-required=\'{{element.elementDefaults.required}}\' name=\'{{element.identifier}}\' class=\'validation-lenient\' data-placement=\'right\' data-toggle=\'tooltip\' tooltip title=\'{{element.elementDefaults.instructions}}\' data-trigger=\'focus\' data-html=\'true\'><i class=\'formcraft-icon\'>email</i></div></label>'
fieldOptions.email = `${labelAndSubLabelTemplate}${columnWidthTemplate}${instructionsAltTemplate}<label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.autoresponder'> Send Autoresponder <span class='more-info'>Autoresponder settings are available under Settings -> Email -> Email Autoresponders</span></label></label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.replyTo'> Set as Reply-To Address</label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.required'> Required Field</label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.readonly'> Read-Only Field</label>${hideFieldTemplate}`

fieldHTML.password = '<label class=\'password-cover field-cover\'><span class=\'sub-label-{{element.elementDefaults.has_sub_label}}\'><span compilesafe=\'element.elementDefaults.main_label\' class=\'main-label\'></span><span class=\'sub-label\' compilesafe=\'element.elementDefaults.sub_label\'></span></span><div><span class=\'error\'></span><input placeholder=\'{{element.elementDefaults.main_label_placeholder}}\' data-field-id=\'{{element.identifier}}\' type=\'password\' data-min-char=\'{{element.elementDefaults.Validation.minChar}}\' data-max-char=\'{{element.elementDefaults.Validation.maxChar}}\' data-val-type=\'{{element.elementDefaults.Validation.allowed}}\' data-regexp=\'{{element.elementDefaults.Validation.regexp}}\' data-is-required=\'{{element.elementDefaults.required}}\' name=\'{{element.identifier}}\' class=\'validation-lenient\' data-placement=\'right\' data-toggle=\'tooltip\' tooltip title=\'{{element.elementDefaults.instructions}}\' data-trigger=\'focus\' data-html=\'true\'></div></label>'
fieldOptions.password = `${labelAndSubLabelTemplate}${columnWidthTemplate}${instructionsTemplate}<label class='w-3'><span>Validation</span><select ng-model='element.elementDefaults.Validation.allowed'><option value='>None</option><option value='alphabets'>Only Alphabets</option><option value='numbers'>Only Numbers</option><option value='alphanumeric'>Only Alphabets & Numbers</option><option value='regexp'>RegEx</option></select></label><label ng-slide-toggle='element.elementDefaults.Validation.allowed=="regexp"' class='w-3'><span>RegEx</span><input type='text' ng-model='element.elementDefaults.Validation.regexp'><i data-html='true' tooltip data-placement='top' data-toggle='tooltip' title='<strong>Common RegExp:</strong><br><strong>/^[a-z0-9_-]{6,18}$/</strong>: allow only alphabets, numbers, underscore and hyphen, and between 6 to 18 characters.<br><strong>/^[a-z0-9-]+$/</strong>: allow only alphabets, numbers and hyphens.<br><strong>/^[a-zA-Z]*$/</strong>: alphabets only, lower or upper case<br><strong>/^[0-9]*$/</strong>: digits only' class='formcraft-icon tooltip-icon'>info_outline</i></label><label class='w2-1'><span>Min Chars</span><input type='text' ng-model='element.elementDefaults.Validation.minChar'></label><label class='w2-1'><span>Max Chars</span><input type='text' ng-model='element.elementDefaults.Validation.maxChar'></label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.Validation.spaces'> Allow Spaces</label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.required'> Required Field</label>${hideFieldTemplate}`

fieldHTML.textarea = '<label class=\'textarea-cover field-cover\'><span class=\'sub-label-{{element.elementDefaults.has_sub_label}}\'><span compilesafe=\'element.elementDefaults.main_label\' class=\'main-label\'></span><span class=\'sub-label\' compilesafe=\'element.elementDefaults.sub_label\'></span></span><div><span class=\'error\'></span><textarea data-field-id=\'{{element.identifier}}\' placeholder=\'{{element.elementDefaults.main_label_placeholder}}\' class=\'validation-lenient\' name=\'{{element.identifier}}\' value=\'\' rows=\'{{element.elementDefaults.field_height}}\' data-min-char=\'{{element.elementDefaults.Validation.minChar}}\' data-max-char=\'{{element.elementDefaults.Validation.maxChar}}\' data-is-required=\'{{element.elementDefaults.required}}\' data-placement=\'right\' data-toggle=\'tooltip\' tooltip title=\'{{element.elementDefaults.instructions}}\' data-trigger=\'focus\' data-html=\'true\'></textarea><div class=\'count-{{element.elementDefaults.show_count}}\'><span class=\'current-count\'>0</span> / <span class=\'max-count\'>{{element.elementDefaults.Validation.maxChar}}</span></div></div></label>'
fieldOptions.textarea = `${labelAndSubLabelTemplate}${columnWidthTemplate}${instructionsAltTemplate}<label class='w-1'><span>Rows</span><input type='text' ng-model='element.elementDefaults.field_height'></label><label class='w-1'><span>Min Chars</span><input type='text' ng-model='element.elementDefaults.Validation.minChar'></label><label class='w-1'><span>Max Chars</span><input type='text' ng-model='element.elementDefaults.Validation.maxChar'></label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.show_count'> Show Character Count</label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.required'> Required Field</label>${hideFieldTemplate}`

fieldHTML.checkbox = '<div class=\'images-{{element.elementDefaults.allow_images}} checkbox-cover field-cover\'><span class=\'sub-label-{{element.elementDefaults.has_sub_label}}\'><span compilesafe=\'element.elementDefaults.main_label\' class=\'main-label\'></span><span class=\'sub-label\' compilesafe=\'element.elementDefaults.sub_label\'></span></span><div data-placement=\'right\' data-toggle=\'tooltip\' tooltip title=\'{{element.elementDefaults.instructions}}\' data-trigger=\'hover\' data-html=\'true\'><span class=\'error\'></span><label ng-repeat=\'opt in element.elementDefaults.optionsListShow\' style=\'width: {{element.elementDefaults.option_width}}\'><img alt=\'\' src=\'{{element.elementDefaults.imagesListShow[$index].url}}\'/><input data-field-id=\'{{element.identifier}}\' type=\'{{element.elementDefaults.allow_multiple}}\' data-is-required=\'{{element.elementDefaults.required}}\' name=\'{{element.identifier}}[]\' value=\'{{opt.value}}\' class=\'validation-lenient\'><span compilesafe=\'opt.show\'></span></label></div></div>'
fieldOptions.checkbox = `<label class='w-1'><span>Label</span><input type='text' ng-model='element.elementDefaults.main_label'></label><label class='w-1'><span>Sub Label</span><input sub-label type='text' ng-model='element.elementDefaults.sub_label'></label>${columnWidthTemplate}<label class='w-2'><span>Instructions</span><input type='text' ng-model='element.elementDefaults.instructions'></label>${altLabelTemplate}<label class='w-3'><input type='checkbox' value='true' ng-model='element.elementDefaults.allow_images'> Add Images</label><div class='images-{{element.elementDefaults.allow_images}}'><label class='w-3'><i class='formcraft-icon tooltip-icon' tooltip data-toggle='tooltip' title='${translate['Dropdown One']}: <br><strong>100==Apple</strong><br>${translate['Dropdown Two']}<img style="height: 50px" src="${FC.pluginurl}/assets/images/value==text.png"/>'>info_outline</i><span>Options </span><a data-post-id='489' class='trigger-help read-more-textarea'>(read more)</a><textarea rows='5' ng-model='element.elementDefaults.options_list' checkbox-list></textarea></label><label class='w-3 w-3-images'><i class='formcraft-icon tooltip-icon' tooltip data-toggle='tooltip' title='Paste the URL of an image here. This image will be assigned to the first option in your field.<br>Press enter, and paste another URL. This will be assigned to the second option, and so on ...'>info_outline</i><span>Images</span><textarea rows='5' ng-model='element.elementDefaults.images_list' image-list></textarea></label></div><label class='w-3'><span>Option Width</span><input type='text' ng-model='element.elementDefaults.option_width'></label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.allow_multiple' ng-true-value='"checkbox"' ng-false-value='"radio"'> Allow Multiple Selections</label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.required'> Required Field</label>${hideFieldTemplate}`

fieldHTML.dropdown = '<label class=\'dropdown-cover field-cover autocomplete-type-{{element.elementDefaults.autocomplete}}\'><span class=\'sub-label-{{element.elementDefaults.has_sub_label}}\'><span compilesafe=\'element.elementDefaults.main_label\' class=\'main-label\'></span><span class=\'sub-label\' compilesafe=\'element.elementDefaults.sub_label\'></span></span><div><span class=\'error\'></span><select data-is-required=\'{{element.elementDefaults.required}}\' class=\'validation-lenient\' data-field-id=\'{{element.identifier}}\' name=\'{{element.identifier}}\' data-placement=\'right\' data-toggle=\'tooltip\' tooltip title=\'{{element.elementDefaults.instructions}}\' data-trigger=\'hover\' data-html=\'true\'><option value=\'{{opt.value}}\' ng-repeat=\'opt in element.elementDefaults.optionsListShow\'>{{opt.show}}</option></select><input type="text"/></div></label>'
fieldOptions.dropdown = `<label class='w-1'><span>Label</span><input type='text' ng-model='element.elementDefaults.main_label'></label><label class='w-1'><span>Sub Label</span><input fc-placeholder sub-label type='text' ng-model='element.elementDefaults.sub_label'></label>${columnWidthTemplate}${instructionsTemplate}${altLabelTemplate}<label class='w-3'><i class='formcraft-icon tooltip-icon' tooltip data-toggle='tooltip' title='${translate['Dropdown One']}: <br><strong>100==Apple</strong><br>${translate['Dropdown Two']}<img style="height: 50px" src="${FC.pluginurl}/assets/images/value==text.png"/>'>info_outline</i><span>Options </span><a data-post-id='489' class='trigger-help read-more-textarea'>(read more)</a><textarea rows='5' ng-model='element.elementDefaults.options_list' checkbox-list></textarea></label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.autocomplete'> Autocomplete Type</label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.required'> Required Field</label>${hideFieldTemplate}<div class='w-3' style='white-space:normal'>Autofill: <a ng-click='addCountries($parent.$index, $index)'>Countries</a>, <a ng-click='addStates($parent.$index, $index)'>US States</a>, <a ng-click='addNationalities($parent.$index, $index)'>Nationalities</a>, <a ng-click='addLanguages($parent.$index, $index)'>Languages</a>, <a ng-click='addDays($parent.$index, $index)'>Days of the Week</a>, <a ng-click='addMonths($parent.$index, $index)'>Months</a></div>`

fieldHTML.datepicker = '<label class=\'datepicker-cover field-cover\'><span class=\'sub-label-{{element.elementDefaults.has_sub_label}}\'><span compilesafe=\'element.elementDefaults.main_label\' class=\'main-label\'></span><span class=\'sub-label\' compilesafe=\'element.elementDefaults.sub_label\'></span></span><div><span class=\'error\'></span><input autocomplete=\'off\' data-field-id=\'{{element.identifier}}\' data-field-id=\'{{element.identifier}}\' placeholder=\'{{element.elementDefaults.main_label_placeholder}}\' type=\'text\' class=\'validation-lenient\' data-is-required=\'{{element.elementDefaults.required}}\' datepicker data-date-min-range=\'{{element.elementDefaults.minDateRange}}\' data-date-format=\'{{element.elementDefaults.dateFormat}}\' data-date-days=\'{{element.elementDefaults.dateDays}}\' data-date-min=\'{{element.elementDefaults.minDate}}\' data-date-min-alt=\'{{element.elementDefaults.minDateAlt}}\' data-date-max-alt=\'{{element.elementDefaults.maxDateAlt}}\' data-date-max=\'{{element.elementDefaults.maxDate}}\' data-date-lang=\'{{element.elementDefaults.dateLang}}\' name=\'{{element.identifier}}\' data-placement=\'right\' data-toggle=\'tooltip\' tooltip title=\'{{element.elementDefaults.instructions}}\' data-trigger=\'focus\' data-html=\'true\' ng-model=\'temp\'><i class=\'formcraft-icon\'>date_range</i></div></label>'
fieldOptions.datepicker = `${labelAndSubLabelTemplate}${columnWidthTemplate}${instructionsTemplate}${altLabelTemplate}<label class='w2-1'><span>Lang</span><select ng-model='element.elementDefaults.dateLang'><option value='en'>English</option><option ng-repeat='lang in dateLang' ng-value='lang'>{{lang}}</option></select></label><label class='w2-1'><span>Format</span><select ng-model='element.elementDefaults.dateFormat'><option>M d, yy</option><option>d M yy</option><option>yy-mm-dd</option><option>dd/mm/yy</option><option>dd.mm.yy</option><option>mm/dd/yy</option></select></label><label class='w2-1'><i class='formcraft-icon tooltip-icon' tooltip data-toggle='tooltip' title='To set today as the min allowed date, type in:<br><strong>0</strong><br>To set day-before-yesterday as the min date, type in <br><strong>-2</strong>'>info_outline</i><span>Min Date</span><input data-default-date='{{element.elementDefaults.minDate}}' type='text' data-date-format='yy-mm-dd' datepicker ng-model='element.elementDefaults.minDate'></label><label class='w2-1'><i class='formcraft-icon tooltip-icon' tooltip data-toggle='tooltip' title='To set today as the max allowed date, type in:<br><strong>0</strong><br>To set day-after-tomorrow as the max date, type in <br><strong>2</strong>'>info_outline</i><span>Max Date</span><input data-default-date='{{element.elementDefaults.maxDate}}' type='text' data-date-format='yy-mm-dd' datepicker ng-model='element.elementDefaults.maxDate' data-date-min='{{element.elementDefaults.minDate}}'></label><label class='w-3'><span>Min Date Field (used to create a date range)</span><input placeholder='[field32]' type='text' ng-model='element.elementDefaults.minDateRange'></label><div class='w-3 week-days'>Days Allowed:<br><label><input type='checkbox' ng-model='element.elementDefaults.dateDays[0]'/> Sunday</label><label><input type='checkbox' ng-model='element.elementDefaults.dateDays[1]'/> Monday</label><label><input type='checkbox' ng-model='element.elementDefaults.dateDays[2]'/> Tuesday</label><label><input type='checkbox' ng-model='element.elementDefaults.dateDays[3]'/> Wednesday</label><label><input type='checkbox' ng-model='element.elementDefaults.dateDays[4]'/> Thursday</label><label><input type='checkbox' ng-model='element.elementDefaults.dateDays[5]'/> Friday</label><label><input type='checkbox' ng-model='element.elementDefaults.dateDays[6]'/> Saturday</label></div><hr/><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.required'> Required Field</label>${hideFieldTemplate}`

fieldHTML.customText = '<div class=\'absolute-{{element.elementDefaults.floating_type}} customText-cover field-cover\' style=\'left: {{element.elementDefaults.leftPosition}}; top: {{element.elementDefaults.topPosition}};right: {{element.elementDefaults.rightPosition}};bottom: {{element.elementDefaults.bottomPosition}};color: {{element.elementDefaults.font_color}} !important; background-color: {{element.elementDefaults.background_color}}\'><div class=\'full\' compile=\'element.elementDefaults.html\' style=\'text-align: {{element.elementDefaults.alignment}}\'></div><input type=\'hidden\' name=\'{{element.identifier}}\' value=\'{{element.elementDefaults.field_value}}\' data-field-id=\'{{element.identifier}}\'></div>'
fieldOptions.customText = `<label class='w-2'><span>Label</span><input type='text' ng-model='element.elementDefaults.main_label'></label>${columnWidthTemplate}<label class='w-2'><span>Field Value</span><input type='text' ng-model='element.elementDefaults.field_value'></label>${altLabelTemplate}<div><div>Position</div><div class='w2-2'><span class='overlap-label'>Top</span><input type='text' placeholder='100px' ng-model='element.elementDefaults.topPosition'/></div><div class='w2-2'><span class='overlap-label'>Right</span><input type='text' placeholder='100px' ng-model='element.elementDefaults.rightPosition'/></div><div class='w2-2'><span class='overlap-label'>Bottom</span><input type='text' placeholder='100px' ng-model='element.elementDefaults.bottomPosition'/></div><div class='w2-2'><span class='overlap-label'>Left</span><input type='text' placeholder='100px' ng-model='element.elementDefaults.leftPosition'/></div></div><div class='w-3'><span>Display</span><br/><div class='button-checkbox-group type-text'><label><input type='radio' update-label name='pos_float_{{$index}}' ng-model='element.elementDefaults.floating_type' value='true'/><img src='${FC.pluginurl}/assets/images/display-floating.png'/>Overlap</label><label><input type='radio' update-label name='pos_float_{{$index}}' ng-model='element.elementDefaults.floating_type' value='false'/><img src='${FC.pluginurl}/assets/images/display-inline.png'/>Inline</label></div></div><div class='w-3'><span>Text Content</span><text-angular class='textangular' ng-model='element.elementDefaults.html'></text-angular></div><div class='w-3'><p style='width: 192px'>Font Color</p><input angular-color type='text' value='#fff' class='color-picker' ng-model='element.elementDefaults.font_color'></div><div class='w-3'><p style='width: 192px'>Background Color</p><input angular-color type='text' value='#fff' class='color-picker' ng-model='element.elementDefaults.background_color'></div>${hideFieldTemplate}`

fieldHTML.submit = '<div class=\'align-{{element.elementDefaults.alignment}} wide-{{element.elementDefaults.isWide}} submit-cover field-cover\'><button type=\'submit\' class=\'button submit-button\'><span class=\'text\'>{{element.elementDefaults.main_label}}</span><span class=\'spin-cover\'><i style=\'color: {{element.elementDefaults.font_color}}\' class=\'loading-icon icon-cog animate-spin\'></i></span></button></div><div class=\'submit-response\'></div><label><input type=\'text\' class=\'required_field\' name=\'website\' autocomplete=\'maple-syrup-pot\'></label>'
fieldOptions.submit = `<label class='w-2'><span>Label</span><input type='text' ng-model='element.elementDefaults.main_label'></label>${columnWidthTemplate}<div class='w-3'><span>Alignment</span><br/><div class='button-checkbox-group'><label class='button-checkbox'><i class='formcraft-icon'>format_align_left</i><input type='radio' name='{{element.identifier}}_name' ng-model='element.elementDefaults.alignment' value='left' update-label/></label><label class='button-checkbox'><i class='formcraft-icon'>format_align_center</i><input type='radio' name='{{element.identifier}}_name' ng-model='element.elementDefaults.alignment' value='center' update-label/></label><label class='button-checkbox'><i class='formcraft-icon'>format_align_right</i><input type='radio' name='{{element.identifier}}_name' ng-model='element.elementDefaults.alignment' value='right' update-label /></label></div></div><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.isWide'> Wide Button</label>${hideFieldTemplate}`

fieldHTML.fileupload = '<label class=\'wide-{{element.elementDefaults.isWide}} fileupload-cover field-cover\'><span class=\'sub-label-{{element.elementDefaults.has_sub_label}}\'><span compilesafe=\'element.elementDefaults.main_label\' class=\'main-label\'></span><span class=\'sub-label\' compilesafe=\'element.elementDefaults.sub_label\'></span></span><div><span class=\'error\'></span><div class=\'button button-file fileupload-button\' data-placement=\'right\' data-toggle=\'tooltip\' tooltip title=\'{{element.elementDefaults.instructions}}\' data-trigger=\'hover\' data-html=\'true\'><i class=\'icon-upload-cloud formcraft-icon\'>cloud_upload</i><span>{{element.elementDefaults.button_label}}</span><input type=\'file\' data-name-list=\'{{element.identifier}}\' name=\'files\' multiple data-allow-extensions=\'{{element.elementDefaults.allow_extensions}}\' data-min-files=\'{{element.elementDefaults.min_files}}\' data-max-files=\'{{element.elementDefaults.max_files}}\' data-max-size=\'{{element.elementDefaults.max_file_size}}\'/></div></div></label>'
fieldOptions.fileupload = `<label class='w-2'><span>Label</span><input type='text' ng-model='element.elementDefaults.main_label'></label><label class='w-1'><span>Sub Label</span><input type='text' ng-model='element.elementDefaults.sub_label'></label><label class='w-2'><span>Button</span><input type='text' ng-model='element.elementDefaults.button_label'></label>${columnWidthTemplate}${instructionsTemplate}${altLabelTemplate}<label class='w-3'><span>Allowed Extensions</span><i class='formcraft-icon tooltip-icon' tooltip data-toggle='tooltip' title='Enter the file extensions users are allowed to upload, separated by a comma.<br>Leave blank to allow all file-types.'>info_outline</i><input type='text' placeholder='jpg, png, gif' ng-model='element.elementDefaults.allow_extensions'></label><label class='w2-1'><span>Min Files</span><input type='text' ng-model='element.elementDefaults.min_files'></label><label class='w2-1'><span>Max Files</span><input type='text' ng-model='element.elementDefaults.max_files'></label><label class='w-3'><span>Max File Size (in KBs)</span><input type='text' ng-model='element.elementDefaults.max_file_size'></label>${hideFieldTemplate}`

fieldHTML.slider = '<label class=\'slider-cover field-cover show-scale-{{element.elementDefaults.scale_true}}\'><span class=\'sub-label-{{element.elementDefaults.has_sub_label}}\'><span compilesafe=\'element.elementDefaults.main_label\' class=\'main-label\'></span><span class=\'sub-label\' compilesafe=\'element.elementDefaults.sub_label\'></span></span><div data-placement=\'right\' data-toggle=\'tooltip\' tooltip title=\'{{element.elementDefaults.instructions}}\' data-trigger=\'hover\' data-html=\'true\'><span class=\'error\'></span><span class=\'range-min\'>{{element.elementDefaults.prefix}}{{element.elementDefaults.range_min}}{{element.elementDefaults.suffix}}</span><span class=\'ui-slider-cover\'><span range-min=\'{{element.elementDefaults.range_min}}\' range-max=\'{{element.elementDefaults.range_max}}\' range-step=\'{{element.elementDefaults.range_step}}\' range-true=\'{{element.elementDefaults.range_true}}\' data-prefix=\'{{element.elementDefaults.prefix}}\' data-suffix=\'{{element.elementDefaults.suffix}}\' slider></span></span><span class=\'range-max\'>{{element.elementDefaults.prefix}}{{element.elementDefaults.range_max}}{{element.elementDefaults.suffix}}</span><input name=\'{{element.identifier}}\' data-field-id=\'{{element.identifier}}\' type=\'hidden\' class=\'validation-lenient\' data-is-required=\'{{element.elementDefaults.required}}\'/></div></label>'
fieldOptions.slider = `<label class='w-1'><span>Label</span><input type='text' ng-model='element.elementDefaults.main_label'></label><label class='w-1'><span>Sub Label</span><input type='text' ng-model='element.elementDefaults.sub_label'></label>${columnWidthTemplate}${instructionsAltTemplate}<label class='w-1'><span>Min</span><input type='text' ng-model='element.elementDefaults.range_min'></label><label class='w-1'><span>Max</span><input type='text' ng-model='element.elementDefaults.range_max'></label><label class='w-1'><span>Step</span><input type='text' ng-model='element.elementDefaults.range_step'></label><label class='w-1'><span>Prefix</span><input type='text' ng-model='element.elementDefaults.prefix' ng-trim='false'></label><label class='w-1'><span>Suffix</span><input type='text' ng-model='element.elementDefaults.suffix' ng-trim='false'></label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.range_true' value='true'> Range Selector</label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.scale_true' value='true'> Show Scale</label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.required'> Required Field</label>${hideFieldTemplate}`

fieldHTML.timepicker = '<div class=\'timepicker-cover field-cover\'><span class=\'sub-label-{{element.elementDefaults.has_sub_label}}\'><span compilesafe=\'element.elementDefaults.main_label\' class=\'main-label\'></span><span class=\'sub-label\' compilesafe=\'element.elementDefaults.sub_label\'></span></span><div><span class=\'error\'></span><span class=\'time-fields-cover hide-meridian-{{element.elementDefaults.format_24}}\' data-placement=\'right\' data-toggle=\'tooltip\' tooltip title=\'{{element.elementDefaults.instructions}}\' data-trigger=\'hover\' data-html=\'true\'><select update-hours hrs-min=\'{{element.elementDefaults.hrs_min}}\' hrs-max=\'{{element.elementDefaults.hrs_max}}\' hrs-step=\'{{element.elementDefaults.hrs_step}}\'><option ng-repeat=\'hours in element.elementDefaults.hoursRange\' value=\'{{hours}}\'>{{hours}}</option></select><select update-minutes minute-step=\'{{element.elementDefaults.minute_step}}\'><option ng-repeat=\'minute in element.elementDefaults.minute_range\' value=\'{{minute}}\'>{{minute}}</option></select><input type=\'text\' class=\'meridian-picker\' value=\'am\'></span><input type=\'hidden\' name=\'{{element.identifier}}\' data-field-id=\'{{element.identifier}}\'><i class=\'formcraft-icon\'>access_time</i></div></div>'
fieldOptions.timepicker = `<label class='w-1'><span>Label</span><input type='text' ng-model='element.elementDefaults.main_label'></label><label class='w-1'><span>Sub Label</span><input type='text' ng-model='element.elementDefaults.sub_label'></label>${columnWidthTemplate}${instructionsTemplate}${altLabelTemplate}<label class='w2-1'><span>Min Hrs</span><input type='text' ng-model='element.elementDefaults.hrs_min'></label><label class='w2-1'><span>Max Hrs</span><input type='text' ng-model='element.elementDefaults.hrs_max'></label><label class='w2-1'><span>Hrs Step</span><input type='text' ng-model='element.elementDefaults.hrs_step'></label><label class='w2-1'><span>Minute Step</span><input type='text' ng-model='element.elementDefaults.minute_step'></label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.format_24'> Hide AM / PM</label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.required'> Required Field</label>${hideFieldTemplate}`

fieldHTML.address = '<label class=\'address-cover field-cover\'><span class=\'sub-label-{{element.elementDefaults.has_sub_label}}\'><span compilesafe=\'element.elementDefaults.main_label\' class=\'main-label\'></span><span class=\'sub-label\' compilesafe=\'element.elementDefaults.sub_label\'></span></span><div><span class=\'error\'></span><input autocomplete=\'off\' class=\'address-picker-field\' type=\'text\' placeholder="{{element.elementDefaults.main_label_placeholder}}" data-show-map=\'{{element.elementDefaults.map}}\' data-map-restrict=\'{{element.elementDefaults.restrict}}\' data-map-height=\'{{element.elementDefaults.map_height}}\' data-field-id=\'{{element.identifier}}\'><input class=\'address-picker-field-hidden\' type=\'hidden\' name=\'{{element.identifier}}\'><div class=\'address-field-map\'></div></div></label>'
fieldOptions.address = `<label class='w-1'><span>Label</span><input fc-placeholder type='text' ng-model='element.elementDefaults.main_label'></label><label class='w-1'><span>Sub Label</span><input type='text' ng-model='element.elementDefaults.sub_label'></label>${columnWidthTemplate}${altLabelTemplate}<label class='w-2'></label><label class='w-2'><span>Google API Key</span><input type='text' ng-model='element.elementDefaults.google_key'></label><label class='w-1'><span>Map Height</span><input type='text' ng-model='element.elementDefaults.map_height'></label><label class='w-3'><span>Restrict To Country</span><input type='text' ng-model='element.elementDefaults.restrict' placeholder='CA'></label><p>Click on Get A Key button on <a href='https://developers.google.com/maps/documentation/javascript/get-api-key' target='_blank'>this</a> page to get your Google API Key.</p><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.map'> Show Map</label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.required'> Required Field</label>${hideFieldTemplate}`

fieldHTML.star = '<div class=\'star-cover field-cover\'><span class=\'sub-label-{{element.elementDefaults.has_sub_label}}\'><span compilesafe=\'element.elementDefaults.main_label\' class=\'main-label\'></span><span class=\'sub-label\' compilesafe=\'element.elementDefaults.sub_label\'></span></span><div class=\'star-label-cover\' data-placement=\'right\' data-toggle=\'tooltip\' tooltip title=\'{{element.elementDefaults.instructions}}\' data-trigger=\'hover\' data-html=\'true\'><span class=\'error\'></span><div><label ng-repeat=\'opt in element.elementDefaults.optionsListShow\' tooltip data-toggle=\'tooltip\' title=\'{{opt.show}}\' style=\'width: {{element.elementDefaults.option_width}}\'><i class=\'formcraft-icon\'>star</i><input data-field-id=\'{{element.identifier}}\' type=\'radio\' data-is-required=\'{{element.elementDefaults.required}}\' name=\'{{element.identifier}}\' value=\'{{opt.value}}\' class=\'validation-lenient\'></label></div></div></div>'
fieldOptions.star = `<label class='w-1'><span>Label</span><input type='text' ng-model='element.elementDefaults.main_label'></label><label class='w-1'><span>Sub Label</span><input sub-label type='text' ng-model='element.elementDefaults.sub_label'></label>${columnWidthTemplate}${instructionsTemplate}${altLabelTemplate}<div><label class='w-3'><i class='formcraft-icon tooltip-icon' tooltip data-toggle='tooltip' title='${translate['Dropdown One']}: <br><strong>100==Apple</strong><br>${translate['Dropdown Two']}<img style="height: 50px" src="${FC.pluginurl}/assets/images/value==text.png"/>'>info_outline</i><span>Options</span><textarea rows='5' ng-model='element.elementDefaults.options_list' checkbox-list></textarea></label></div><label class='w-3'><span>Option Width</span><input type='text' ng-model='element.elementDefaults.option_width'></label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.required'> Required Field</label>${hideFieldTemplate}`

fieldHTML.thumb = '<div class=\'thumb-cover field-cover\'><span class=\'sub-label-{{element.elementDefaults.has_sub_label}}\'><span compilesafe=\'element.elementDefaults.main_label\' class=\'main-label\'></span><span class=\'sub-label\' compilesafe=\'element.elementDefaults.sub_label\'></span></span><div class=\'thumb-label-cover hide-checkbox update-label\' data-placement=\'right\' data-toggle=\'tooltip\' tooltip title=\'{{element.elementDefaults.instructions}}\' data-trigger=\'hover\' data-html=\'true\'><span class=\'error\'></span><div><label ng-class-odd=\'' + '"odd"' + '\' ng-repeat=\'opt in element.elementDefaults.optionsListShow\' tooltip data-toggle=\'tooltip\' title=\'{{opt.show}}\' style=\'width: {{element.elementDefaults.option_width}}\'><i class=\'formcraft-icon thumbs-up\'>thumb_up</i><i class=\'formcraft-icon thumbs-down\'>thumb_down</i><input data-field-id=\'{{element.identifier}}\' type=\'radio\' data-is-required=\'{{element.elementDefaults.required}}\' name=\'{{element.identifier}}\' value=\'{{opt.value}}\' class=\'validation-lenient\'></label></div></div></div>'
fieldOptions.thumb = `<label class='w-1'><span>Label</span><input type='text' ng-model='element.elementDefaults.main_label'></label><label class='w-1'><span>Sub Label</span><input sub-label type='text' ng-model='element.elementDefaults.sub_label'></label>${columnWidthTemplate}${instructionsTemplate}${altLabelTemplate}<div><label class='w-3'><i class='formcraft-icon tooltip-icon' tooltip data-toggle='tooltip' title='${translate['Dropdown One']}: <br><strong>100==Apple</strong><br>${translate['Dropdown Two']}<img style="height: 50px" src="${FC.pluginurl}/assets/images/value==text.png"/>'>info_outline</i><span>Options</span><textarea rows='5' ng-model='element.elementDefaults.options_list' checkbox-list></textarea></label></div><label class='w-3'><span>Option Width</span><input type='text' ng-model='element.elementDefaults.option_width'></label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.required'> Required Field</label>${hideFieldTemplate}`

fieldHTML.matrix = '<div class=\'matrix-cover field-cover\'><span class=\'sub-label-{{element.elementDefaults.has_sub_label}}\'><span compilesafe=\'element.elementDefaults.main_label\' class=\'main-label\'></span><span class=\'sub-label\' compilesafe=\'element.elementDefaults.sub_label\'></span></span><div><span class=\'error\'></span><div data-placement=\'right\' data-toggle=\'tooltip\' tooltip title=\'{{element.elementDefaults.instructions}}\' data-trigger=\'hover\' data-html=\'true\'><table cellspacing=\'0\' cellpadding=\'0\'><thead><th></th><th ng-repeat=\'col in element.elementDefaults.matrixColumnsOutput\'>{{col.value}}</th></thead><tbody><tr ng-repeat=\'row in element.elementDefaults.matrixRowsOutput\'><td>{{row.value}}</td><td ng-repeat=\'col in element.elementDefaults.matrixColumnsOutput\'><label><input type=\'radio\' name=\'{{element.identifier}}_{{$parent.$index}}\' value=\'{{col.value}}\'></label></td></tr></tbody></table></div></div></div>'
fieldOptions.matrix = `<label class='w-1'><span>Label</span><input type='text' ng-model='element.elementDefaults.main_label'></label><label class='w-1'><span>Sub Label</span><input sub-label type='text' ng-model='element.elementDefaults.sub_label'></label>${columnWidthTemplate}${instructionsTemplate}${altLabelTemplate}<div><label class='w-3'><span>Options</span><textarea rows='5' ng-model='element.elementDefaults.matrix_rows' matrix-rows></textarea></label><label class='w-3'><span>Columns</span><textarea rows='5' ng-model='element.elementDefaults.matrix_cols' matrix-cols></textarea></label><label class='w-3'><input type='checkbox' ng-model='element.elementDefaults.required'> Required Field</label>${hideFieldTemplate}`

export { fieldHTML, fieldOptions }
