<?php

namespace FedExVendor\FedEx\PickupService\SimpleType;

use FedExVendor\FedEx\AbstractSimpleType;
/**
 * PickupExceptionType
 *
 * @author      Jeremy Dunn <jeremy@jsdunn.info>
 * @package     PHP FedEx API wrapper
 * @subpackage  Pickup Service
 */
class PickupExceptionType extends AbstractSimpleType
{
    const _ATTEMPTED_AFTER_CLOSE_TIME = 'ATTEMPTED_AFTER_CLOSE_TIME';
    const _ATTEMPTED_OUT_OF_WINDOW = 'ATTEMPTED_OUT_OF_WINDOW';
    const _BUSINESS_CLOSED = 'BUSINESS_CLOSED';
    const _BUSINESS_ON_STRIKE = 'BUSINESS_ON_STRIKE';
    const _CITY_NOT_IN_SERVICE_AREA = 'CITY_NOT_IN_SERVICE_AREA';
    const _COMAIL_STOP = 'COMAIL_STOP';
    const _COMMODITY_UNACCEPTABLE = 'COMMODITY_UNACCEPTABLE';
    const _CORRECTIVE_PICKUP = 'CORRECTIVE_PICKUP';
    const _COURIER_ATTEMPTED_PACKAGE_LEFT_BEHIND = 'COURIER_ATTEMPTED_PACKAGE_LEFT_BEHIND';
    const _CUSTOMER_DELAY = 'CUSTOMER_DELAY';
    const _CUSTOMER_DID_NOT_WAIT = 'CUSTOMER_DID_NOT_WAIT';
    const _CUSTOMER_NOT_AT_PICKUP_LOCATION = 'CUSTOMER_NOT_AT_PICKUP_LOCATION';
    const _CUSTOMER_SECURITY_DELAY = 'CUSTOMER_SECURITY_DELAY';
    const _EXCEED_SERVICE_LIMITS = 'EXCEED_SERVICE_LIMITS';
    const _FUTURE_DELIVERY_REQUESTED = 'FUTURE_DELIVERY_REQUESTED';
    const _HAZARD_TO_COURIER = 'HAZARD_TO_COURIER';
    const _HAZMAT_PICKUP_NOT_COMPLETED = 'HAZMAT_PICKUP_NOT_COMPLETED';
    const _INCORRECT_ADDRESS = 'INCORRECT_ADDRESS';
    const _INCORRECT_PICKUP_INFORMATION = 'INCORRECT_PICKUP_INFORMATION';
    const _INCORRECT_ROUTE = 'INCORRECT_ROUTE';
    const _INTERLINE_PICKUP = 'INTERLINE_PICKUP';
    const _LOCAL_EVENT = 'LOCAL_EVENT';
    const _MASS_PICKUP_SCAN = 'MASS_PICKUP_SCAN';
    const _MASS_ROUTING_SCAN = 'MASS_ROUTING_SCAN';
    const _MISSING_REGULATORY_PAPERWORK = 'MISSING_REGULATORY_PAPERWORK';
    const _MULTIPLE_PICKUPS_SCHEDULED = 'MULTIPLE_PICKUPS_SCHEDULED';
    const _NO_CREDIT_APPROVAL_BULK_SHIPMENT = 'NO_CREDIT_APPROVAL_BULK_SHIPMENT';
    const _NO_PACKAGE = 'NO_PACKAGE';
    const _NO_PICKUP_ATTEMPT_MADE = 'NO_PICKUP_ATTEMPT_MADE';
    const _OTHER = 'OTHER';
    const _PACKAGE_ALREADY_TENDERED = 'PACKAGE_ALREADY_TENDERED';
    const _PACKAGE_MOVEMENT_NOT_SUPPORTED = 'PACKAGE_MOVEMENT_NOT_SUPPORTED';
    const _PACKAGE_RECEIVED_AFTER_SHUTTLE_DEPARTED = 'PACKAGE_RECEIVED_AFTER_SHUTTLE_DEPARTED';
    const _PACKAGE_RETRIEVAL = 'PACKAGE_RETRIEVAL';
    const _PACKAGE_TENDERED_TO_OTHER_CARRIER = 'PACKAGE_TENDERED_TO_OTHER_CARRIER';
    const _PACKAGE_TENDERED_TO_OTHER_FEDEX_CARRIER = 'PACKAGE_TENDERED_TO_OTHER_FEDEX_CARRIER';
    const _PACKAGE_TRANSFERRED_TO_OTHER_CARRIER = 'PACKAGE_TRANSFERRED_TO_OTHER_CARRIER';
    const _PAYMENT_RECEIVED = 'PAYMENT_RECEIVED';
    const _PICKUP_CANCELLED = 'PICKUP_CANCELLED';
    const _PICKUP_NOT_READY = 'PICKUP_NOT_READY';
    const _PICKUP_ORIGIN_HOLIDAY = 'PICKUP_ORIGIN_HOLIDAY';
    const _PICKUP_SUSPENDED = 'PICKUP_SUSPENDED';
    const _PICKUP_TYPE_RESTRICTED = 'PICKUP_TYPE_RESTRICTED';
    const _PICKUP_UPON_DELIVERY = 'PICKUP_UPON_DELIVERY';
    const _PREROUTED_METER_PACKAGE = 'PREROUTED_METER_PACKAGE';
    const _REROUTED = 'REROUTED';
    const _SCHEDULED_PAST_CUTOFF = 'SCHEDULED_PAST_CUTOFF';
    const _SYSTEM_OUTAGE_NO_PICKUP = 'SYSTEM_OUTAGE_NO_PICKUP';
    const _TENDERED_BY_CARTAGE_AGENT = 'TENDERED_BY_CARTAGE_AGENT';
    const _THIRD_PARTY_CALL_IN = 'THIRD_PARTY_CALL_IN';
    const _UNABLE_TO_COLLECT_PAYMENT = 'UNABLE_TO_COLLECT_PAYMENT';
    const _UNABLE_TO_SCAN_PACKAGE = 'UNABLE_TO_SCAN_PACKAGE';
    const _UNEXPECTED_DELAY = 'UNEXPECTED_DELAY';
    const _WEATHER_DELAY = 'WEATHER_DELAY';
}
