<?php

namespace FedExVendor\FedEx\PackageMovementInformationService\ComplexType;

use FedExVendor\FedEx\AbstractComplexType;
/**
 * Postal Code Service Area description.
 *
 * @author      Jeremy Dunn <jeremy@jsdunn.info>
 * @package     PHP FedEx API wrapper
 * @subpackage  Package Movement Information Service
 *
 * @property string $LocationId
 * @property string $StateOrProvinceCode
 * @property string $PostalCode
 * @property string $ServiceArea
 */
class PostalCodeServiceAreaDescription extends AbstractComplexType
{
    /**
     * Name of this complex type
     *
     * @var string
     */
    protected $name = 'PostalCodeServiceAreaDescription';
    /**
     * Location ID
     *
     * @param string $locationId
     * @return $this
     */
    public function setLocationId($locationId)
    {
        $this->values['LocationId'] = $locationId;
        return $this;
    }
    /**
     * State or Province code
     *
     * @param string $stateOrProvinceCode
     * @return $this
     */
    public function setStateOrProvinceCode($stateOrProvinceCode)
    {
        $this->values['StateOrProvinceCode'] = $stateOrProvinceCode;
        return $this;
    }
    /**
     * Postal Code
     *
     * @param string $postalCode
     * @return $this
     */
    public function setPostalCode($postalCode)
    {
        $this->values['PostalCode'] = $postalCode;
        return $this;
    }
    /**
     * Service area code
     *
     * @param string $serviceArea
     * @return $this
     */
    public function setServiceArea($serviceArea)
    {
        $this->values['ServiceArea'] = $serviceArea;
        return $this;
    }
}
